Attribute VB_Name = "modLoad"
Option Explicit

'-------------------------------------------------------------------------------------------
'Description: Deals with primary loading function when the bot initially starts up
'-------------------------------------------------------------------------------------------

Public Sub loadAllInformation() 'This should be the ONLY public function for loading anything.
    Call resetArrays
    Call getFiles
    Call getColors
    Call getProfiles
    Call getBots
    Call beginOutputMethod
    Call getHashPath
    Call getVersionBytes
    Call getFilters
    Call setInitializeLogs
    Call getChannels
    Call getGlobalSettings
    Call getGlobalOptions
    Call beginTimers
    Call getAliases
    Call getPlugins
    Call getLastSeen
End Sub

Private Sub resetArrays()
    'Classes:
    ReDim ProfileHandler(0)
    '   // Battle.net Connection Variables
    ReDim BNETDATA(0)
    '   // Bots Type
    ReDim Bots(0)
End Sub

Private Sub beginOutputMethod()
    If (G_Options.BetaMode) Then
        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "Welcome to " & Bot_Name & " v" & App.Major & "." & App.Minor & " Build: " & App.Revision, COLORS.ID_COLOR_LEAVE, " [Beta Edition]"
    Else
        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "Welcome to " & Bot_Name & " v" & App.Major & "." & App.Minor & " Build: " & App.Revision
    End If
End Sub

Private Sub beginTimers()
    Call timerQueueBotMessages
    Call timerAutoAway
    Call timerNewsRetrieval
End Sub

Private Sub setInitializeLogs()
    Dim LOGHandler As New clsLogging
    Dim i As Integer
    For i = 0 To UBound(Bots) - 1
        If (ProfileHandler(i).OPTION_LOG_CHAT) Then
            Call LOGHandler.logChat(vbCrLf & "/* Bot loaded on " & Date & " at " & Time & ": */", "Logs", Bots(i).Profile, False)
        End If
    Next i
End Sub

Private Sub getFiles()
    Files.Config = App.Path & "\" & "Configuration.ini"
    Files.Settings = App.Path & "\" & "Settings.ini"
    Files.Layout = App.Path & "\" & "Layout.ini"
    Files.Data = App.Path & "\" & "Data.ini"
    Files.Lastseen = App.Path & "\Lastseen.db"
    
    Open Files.Config For Append As #1
    Close #1
    Open Files.Layout For Append As #2
    Close #2
    Open Files.Settings For Append As #3
    Close #3
    Open Files.Data For Append As #4
    Close #4
    Open Files.Lastseen For Append As #5
    Close #5
End Sub

Private Sub getColors()
    setColorValue "ID_COLOR_INFO", ReadINI("Events", "ID_COLOR_INFO", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_EMOTE", ReadINI("Events", "ID_COLOR_EMOTE", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_TALK", ReadINI("Events", "ID_COLOR_TALK", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_WHISFROM", ReadINI("Events", "ID_COLOR_WHISFROM", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_WHISTO", ReadINI("Events", "ID_COLOR_WHISTO", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_WHISP_NAME", ReadINI("Events", "ID_COLOR_WHISP_NAME", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_JOIN", ReadINI("Events", "ID_COLOR_JOIN", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_LEAVE", ReadINI("Events", "ID_COLOR_LEAVE", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_USER", ReadINI("Events", "ID_COLOR_USER", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_TIME", ReadINI("Events", "ID_COLOR_TIME", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_TEXT", ReadINI("Events", "ID_COLOR_TEXT", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_NAMES", ReadINI("Events", "ID_COLOR_NAMES", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_NAMES_2", ReadINI("Events", "ID_COLOR_NAMES_2", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_SUCCEED", ReadINI("Events", "ID_COLOR_SUCCEED", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_FAILED", ReadINI("Events", "ID_COLOR_FAILED", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_PROCESS", ReadINI("Events", "ID_COLOR_PROCESS", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_OPERATOR", ReadINI("Events", "ID_COLOR_OPERATOR", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_SQUELCH", ReadINI("Events", "ID_COLOR_SQUELCH", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_BLIZZARD", ReadINI("Events", "ID_COLOR_BLIZZARD", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_NORMAL", ReadINI("Events", "ID_COLOR_NORMAL", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_SELF", ReadINI("Events", "ID_COLOR_SELF", Files.Layout, "Battle.net")
    setColorValue "ID_COLOR_BRACKET", ReadINI("Events", "ID_COLOR_BRACKET", Files.Layout, "Battle.net")
        
    setColorValue "BOT_COLOR_INFO", ReadINI("Events", "BOT_COLOR_INFO", Files.Layout, "BOT")
    setColorValue "BOT_COLOR_ERROR", ReadINI("Events", "BOT_COLOR_ERROR", Files.Layout, "BOT")
    setColorValue "BOT_COLOR_PROCESS", ReadINI("Events", "BOT_COLOR_PROCESS", Files.Layout, "BOT")
    setColorValue "BOT_COLOR_SUCCEED", ReadINI("Events", "BOT_COLOR_SUCCEED", Files.Layout, "BOT")
    setColorValue "BOT_COLOR_FAILED", ReadINI("Events", "BOT_COLOR_FAILED", Files.Layout, "BOT")
        
    COLORS.DBG_RECEIVED = vbGreen
    COLORS.DBG_SENT = vbYellow
End Sub

Private Sub getHashPath()
    Dim Logging As New clsLogging
    
    With G_Settings
        .STAR_HASH_PATH = Replace$(ReadINI("Global Settings", "STAR", Files.Settings, "Hash Path"), "$dir", App.Path)
        .W2BN_HASH_PATH = Replace$(ReadINI("Global Settings", "W2BN", Files.Settings, "Hash Path"), "$dir", App.Path)
        .D2DV_HASH_PATH = Replace$(ReadINI("Global Settings", "D2DV", Files.Settings, "Hash Path"), "$dir", App.Path)
        .D2XP_HASH_PATH = Replace$(ReadINI("Global Settings", "D2XP", Files.Settings, "Hash Path"), "$dir", App.Path)
        .WAR3_HASH_PATH = Replace$(ReadINI("Global Settings", "WAR3", Files.Settings, "Hash Path"), "$dir", App.Path)
        'Create folders
        Call Logging.makeFolder(.STAR_HASH_PATH)
        Call Logging.makeFolder(.W2BN_HASH_PATH)
        Call Logging.makeFolder(.D2DV_HASH_PATH)
        Call Logging.makeFolder(.D2XP_HASH_PATH)
        Call Logging.makeFolder(.WAR3_HASH_PATH)
    End With
End Sub

Private Sub getVersionBytes()
    With VerByte
        '&H0 in front ensures that some value is used.
        .D2DV = "&H0" & ReadINI("Global Settings", "D2DV", Files.Settings, "Version Byte")
        .D2XP = "&H0" & ReadINI("Global Settings", "D2XP", Files.Settings, "Version Byte")
        .SEXP = "&H0" & ReadINI("Global Settings", "SEXP", Files.Settings, "Version Byte")
        .STAR = "&H0" & ReadINI("Global Settings", "STAR", Files.Settings, "Version Byte")
        .W2BN = "&H0" & ReadINI("Global Settings", "W2BN", Files.Settings, "Version Byte")
        .W3XP = "&H0" & ReadINI("Global Settings", "W3XP", Files.Settings, "Version Byte")
        .WAR3 = "&H0" & ReadINI("Global Settings", "WAR3", Files.Settings, "Version Byte")
        'Debug.Print Hex(.W2BN)
    End With
End Sub

Private Sub getGlobalOptions()
    With G_Options
        .Auto_Away = Val(ReadINI("Global Options", "AUTO_AWAY_ON_IDLE", Files.Settings, "Bot"))
        .Auto_Clear_Chat = Val(ReadINI("Global Options", "AUTO_CLEAR_CHAT", Files.Settings, "Chat"))
        .Auto_Complete = Val(ReadINI("Global Options", "AUTO_COMPLETE", Files.Settings, "Chat"))
        .Auto_Reconnect = Val(ReadINI("Global Options", "AUTO_RECONNECT", Files.Settings, "Connection"))
        .Connect_On_Start = Val(ReadINI("Global Options", "CONNECT_ON_START", Files.Settings, "Connection"))
        .Chat_Brackets = Val(ReadINI("Global Options", "BRACKET_MESSAGING", Files.Settings, "Chat"))
            frmMain.mnuBrackets.Checked = .Chat_Brackets
        .Chat_Filters = Val(ReadINI("Global Options", "CHAT_FILTERS", Files.Settings, "Chat"))
        .Flash_Window_Reply = Val(ReadINI("Global Options", "FLASHWINDOW", Files.Settings, "Notifications"))
            frmMain.mnuFlashWindow.Checked = .Flash_Window_Reply
        .Flood_Bot_Filters = Val(ReadINI("Global Options", "FLOODBOT_FILTERS", Files.Settings, "Chat"))
        .Join_Leave_Reply = Val(ReadINI("Global Options", "JOIN_LEAVE", Files.Settings, "Notifications"))
            frmMain.mnuJoinLeave.Checked = .Join_Leave_Reply
        .Last_Seen_Usage = Val(ReadINI("Global Options", "LASTSEEN_LOGGING", Files.Settings, "Bot"))
        .On_User_Reply = Val(ReadINI("Global Options", "ONUSER", Files.Settings, "Notifications"))
            frmMain.mnuOnUser.Checked = .On_User_Reply
        .Parse_Stats = Val(ReadINI("Global Options", "STATSTRING_PARSING", Files.Settings, "Channel"))
        .Queue_Usage = Val(ReadINI("Global Options", "QUEUE_USAGE", Files.Settings, "Chat"))
        .Show_Available_Channels = Val(ReadINI("Global Options", "SHOW_AVAILABLE_CHANNELS", Files.Settings, "Bot"))
        .Show_Void = Val(ReadINI("Global Options", "SHOW_CHANNEL_VOID", Files.Settings, "Channel"))
        .URL_Dectection = Val(ReadINI("Global Options", "URL_DETECTION", Files.Settings, "Chat"))
        .Color_Code_Users = Val(ReadINI("Global Options", "COLOR_CODE_USERS", Files.Settings, "Channel"))
        .AutoFilters = Val(ReadINI("Global Options", "AUTO_FILTERS", Files.Settings, "Chat"))
        .ParseNews = Val(ReadINI("Global Options", "GET_NEWS", Files.Settings, "Connection"))
    End With
End Sub

Private Sub getGlobalSettings()
    With G_Settings
        .BNLS_Server = ReadINI("Global Settings", "BNLS_SERVER", Files.Settings, "Connection")
        .Reconnect_Delay = Val(ReadINI("Global Settings", "RECONNECT_DELAY", Files.Settings, "Connection"))
        .Connect_Delay = Val(ReadINI("Global Settings", "CONNECT_DELAY", Files.Settings, "Connection"))
        .Clear_Text_Amount = Val(ReadINI("Global Settings", "CLEAR_TEXT_AMOUNT", Files.Settings, "Chat"))
        .AutoAwayTime = Val(ReadINI("Global Settings", "AUTOAWAY_TIME", Files.Settings, "Bot"))
    End With
End Sub

Private Sub getFilters()
    Dim FilterArray()   As String
    Dim spltFilter()    As String
    Dim i               As Integer
    
    FilterArray = getDataList("Filters", Files.Data)
    
    For i = 0 To UBound(FilterArray) - 1
        If InStr(FilterArray(i), Space(1)) Then
            spltFilter() = Split(FilterArray(i), Space(1))
            Select Case UCase$(spltFilter(1))
                Case "USER"
                    Call BotFilters.addFilter(spltFilter(0), F_USER)
                Case "MESSAGE"
                    Call BotFilters.addFilter(spltFilter(0), F_MESSAGE)
            End Select
        End If
    Next i
    
    'Output
    AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "(Filters) Loaded: " & BotFilters.countFilters
End Sub

Private Sub getAliases()
    Dim AliasArray()    As String
    Dim spltAlias()     As String
    Dim i               As Integer
    AliasArray = getDataList("Aliases", Files.Data)

    For i = 0 To UBound(AliasArray) - 1
        If AliasArray(i) <> vbNullString Then
            spltAlias() = Split(AliasArray(i), Space(1), 2)
            Call BotAliases.addAlias(spltAlias(0), spltAlias(1))
        End If
    Next i
    
    AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "(Aliases) Loaded: " & BotAliases.countAliases
End Sub

Private Sub getChannels()
    Dim ChannelArray() As String
    Dim i As Integer
    ChannelArray = getDataList("Channels", Files.Data)

    For i = 0 To UBound(ChannelArray) - 1
        If ChannelArray(i) <> vbNullString Then
            If (i = 0) Then
                frmMain.mnuChannelArray(i).Caption = ChannelArray(i)
            Else
                Load frmMain.mnuChannelArray(frmMain.mnuChannelArray.Count)
                frmMain.mnuChannelArray(frmMain.mnuChannelArray.UBound).Caption = ChannelArray(i)
            End If
        End If
    Next i
End Sub

Private Sub getPlugins()
    Dim Logging As New clsLogging
    Dim PluginName As String
    Dim PluginList() As String
    
    ReDim PluginList(0)
    
    'Create folder
    Call Logging.makeFolder(App.Path & "\Plugins")
    
    'Check for plugins and add them to array
    PluginName = Dir(App.Path & "\Plugins\*.dll")
    If (PluginName <> vbNullString) Then
        PluginList(0) = PluginName
        Do
            PluginName = Dir
            If (PluginName = vbNullString) Then Exit Do
            ReDim Preserve PluginList(UBound(PluginList) + 1)
            PluginList(UBound(PluginList)) = PluginName
        Loop
    End If
    
    'Loop through plugin array and load plugins
    Dim i As Integer
    For i = LBound(PluginList) To UBound(PluginList)
        If (InStr(PluginList(i), ".dll")) Then
            If (PluginHost.loadPlugin((Split(PluginList(i), ".dll")(0)), App.Path & "\Plugins\")) Then
                AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_SUCCEED, "(Plugin) Loaded: " & PluginList(i)
            Else
                AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_SUCCEED, "(Plugin) Loaded: " & PluginList(i)
            End If
        End If
    Next i
End Sub

Private Sub getLastSeen()
    'Must be after profiles and file names have been initiated.
    'Structure:
    '(DWORD)    Profile Amount
    '
    '(STRING)   Profile Name
    '(DWORD)    Amount
    '(STRING)   Username
    '(STRING)   Channel
    '(STRING)   Product
    '(STRING)   Server
    '(DWORD)    FILETIME
    '(DWORD)    Latency
    '(DWORD)    Flags
    
    'Extract data from the lastseen database file
    Dim strData As String
    strData = Space(FileLen(Files.Lastseen))
    Open Files.Lastseen For Binary Access Read As #1
        Get #1, , strData
    Close #1
    
    With PktBuffer
        .Reset
        .SetData strData 'Set the data of the extracted data
        
        'Begin parsing through it.
        Dim ProfileAmount   As Integer
        ProfileAmount = .GetDWORD
        'Debug.Print ProfileAmount
        Dim i               As Integer
        
        'Cycle through all the lastseen databases.
        'Debug.Print DebugOutput(PktBuffer.RawData)
        For i = 1 To ProfileAmount
            Dim ProfileName As String
            ProfileName = .GetString
            'Debug.Print ProfileName
            Dim j   As Integer
            'Search for correct profile, and add information
            For j = 0 To UBound(Bots) - 1
                'Profile found, add information
                If (StrComp(Bots(j).Profile, ProfileName, vbTextCompare) = 0) Then
                    
                    Dim k   As Integer
                    Dim LastSeenAmount As Integer
                    LastSeenAmount = .GetDWORD
                    For k = 1 To LastSeenAmount '(DWORD) Amount
                    
                        Dim Username As String, Channel As String, Product As String, Server As String
                        Dim Filetime As Long, Latency As Long, Flags As Long
                        
                        'Parse information from data
                        Username = .GetString
                        Channel = .GetString
                        Product = .GetString
                        Server = .GetString
                        Filetime = .GetDWORD
                        Latency = .GetDWORD
                        Flags = .GetDWORD
                        
                        'Add data to the class
                        With ProfileHandler(i - 1).Lastseen
                            Call .addLastSeen(Username, Channel, Product, Latency, Flags, Server, Filetime)
                        End With
                    Next k
                    Exit For
                End If
            Next j
        Next i
    End With
End Sub
